<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Specialization extends Model 
{

    protected $table = 'specializations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsToMany('User');
    }

    public function attachments()
    {
        return $this->morphToMany('Attachment', 'attachmentable');
    }

    public function mainSpecialization()
    {
        return $this->belongsTo('Specialization', 'parent_id', 'id');
    }

    public function subSpecializations()
    {
        return $this->hasMany('Specialization', 'id', 'parent_id');
    }

}